#include "tcp.h"

/*	dai now requires 2 x,y pairs as arguments. */ 
/* 	the first pair define CAP, second pair	*/
/* 	define 'opposite corner' of AOI.	*/

dai(capx, capy, oppx, oppy)	/* define area of interest */
int capx, capy, oppx, oppy,;
{
	aedbf[0] = MOV;			/* aedbf[0..3] hold */
	encode(&aedbf[1], capx, capy);  /* MOV(capx,capy) code */

	aedbf[4] = DAI;			/* aedbf[4..7] hold	*/
	encode(&aedbf[5],oppx, oppy);	/* DAI(oppx,oppy code	*/

	obyte(aedbf, 8);
}

/*	copy area of interest, to an area of similar 	*/
/*	size and shape whose lower left corner is at	*/
/*	x, y.						*/

/*	available on AED1024 only	*/

cai(x,y)
int x, y;
{
	aedbf[0] = XTD;
	aedbf[1] = CAI;
	encode(&(aedbf[2]), x, y);
	obyte(aedbf,6);
}

/*	rotate area of interest.		*/
/*	area of interest is scrolled down	*/
/*	arg rows, with wraparound at the top.	*/

/*	available on AED1024 only	*/

rot(arg)
int arg;
{
	aedbf[0] = XTD;
	aedbf[1] = ROT;
	aedbf[2] = arg;
	obyte(aedbf,3);
}

/*	read horizontal runs from AOI			*/
/*	byt must be at least 2*isize+1 bytes long.	*/
/*	byt gets up to isize color/count pairs, + the	*/
/* 	null byte terminator sent by the terminal. 	*/
/*	returns number of count/color pairs read.	*/

rhr(isize,byt)
int isize;
char byt[];
{
	register int i;
	register char *bp = byt,
			*last = byt + (isize << 1);
	aedbf[0]= RHR;
	ordcmd(aedbf,1);
	ibyte(bp,1); 	/* read first count 	*/
	while((bp<last) && *bp){	/* if there's room and count != 0 */
		ibyte(aedbf,2);
		*++bp = aedbf[0];	/* buffer this color	*/
		*++bp = aedbf[1];	/* and next count	*/
	}
	/* if bp < last then *bp = 0 and less than isize pairs were */
	/* read. figure out how many there are and return it.	*/ 

	if(bp<last)
		return((bp-byt)>>1);
	
	/* bp = last. if *bp == 0 thats good, we got isize runs */
	/* else we have array overflow, so gobble up the rest   */
	/* of the color/count pairs and quit	*/

	if(*bp == 0)
		return(isize);

	do{	/* gobble */
		ibyte(aedbf,2); /* get color,count */
	}while( aedbf[1] ); 	/* while count != 0 */

	printf(" aed: ** rhr **  array overflow \n");
	exit(0);
	
}

/*		RHS -- read AOI, starting at CAP.	*/
/*		read entire AOI into byt, n MUST be	*/
/*		number of bytes in AOI as previously 	*/
/*		defined via DAI command.		*/


rhs(n,byt)		
int n;
char byt[];
{
	aedbf[0]=RHS;
	ordcmd(aedbf,1);
	ibyte(byt,n);
}

whc(n16,byt)	/*write horizontal scan ( non AOI ) */
int n16;
char byt[];
{
	aedbf[0] = WHC;
	aedbf[1] = n16.hibyte;
	aedbf[2] = n16.lobyte;
	obyte(aedbf,3);
	obyte(byt,n16);
}

whr(byt)	/* write horizontal runs */
char byt[];
{
	register int i;
	register char *bp = byt;
	
	aedbf[0]= WHR;
	obyte(aedbf,1);

/*	byt is a sequence of count/color pairs, terminated
	by a count of zero.  find the length of the sequence
	and send it.  length must be < 32768.
*/

	for ( i=0; (i >= 0) && *bp; i+=2, bp +=2);
	if ( i < 0 ) { 
		 printf( " aed: ** whr ** error !\n " );
		 exit(0);
	}
	i++;
	obyte(byt,i);
}

whs(n,byt)	/* write horizontal scan */
int n;
char byt[];
{
	aedbf[0]= WHS;
	obyte(aedbf,1);
	obyte(byt,n);
}

whu(n,byt)	/* write horizontal run alternate */
int n;
char byt[];
{
	if ( byt[n-1] != 0 ) {
		printf( " aed: ** whu ** no termination ! \n " );
		exit(0);
	}
	aedbf[0]= WHU;
	obyte(aedbf,1);
	obyte(byt,n);
}

/*	this code forces the reserved bits to	*/
/*	zero - needs to be changed if they ever */
/*	acquire meaning.			*/
/*	probably we should also make sure that  */
/*	bit 5 (16 bit transfers) is set, but	*/
/*	that may be crossing the line between	*/
/*	doing for and doing to.			*/

suc(byt)	/* set up counters for dma */
int byt;
#define RESERVED (128+64)	/* most significant 2 bits */

{
	aedbf[0]= SUC;
	aedbf[1]= (byt & ~RESERVED);
	obyte(aedbf,2);
}
